package cn.com.duiba.kjy.livecenter.api.enums.live.code;

/**
 * Created by dugq on 2020-03-25.
 */
public enum BizErrorCode implements BizErrorCodeInterface {

    // 99 系统级别
    SYSTEM_ERROR("999999","系统错误"),
    PARAM_ERROR("999998","参数错误"),
    DO_NOT_CARE("990000","不关心错误码的异常，自我消化的异常。特殊标记"),


    // 直播公司
    SAVE_LIVE_USER("100001","保存直播用户失败"),
    SAVE_LIVE_AGENT("100002","保存直播代理人失败"),

    //公司管理
    NOT_IN_SAME_TEAM("200001","非团队队员"),
    JOIN_TEAM_ERROR("200002","代理人加入团队失败"),

    //红包
    RED_PACKET_START_LIVE_EXIST("300001", "开播红包已经存在"),
    RED_PACKET_REAL_TIME_EXIST("300002", "尚有未领取完的实时红包"),
    RED_PACKET_START_LIVE_CAN_NO_UPDATE("300003", "开播红包直播开始后不能更改"),
    RED_PACKET_REAL_TIME_CAN_NO_UPDATE("300004", "实时红包不能更新"),
    RED_PACKET_RANDOM_ALGORITHM("300005", "红包拆分出错"),
    RED_PACKET_REAL_TIME_LIMIT("300006", "实时红包扣除限额失败"),
    RED_PACKET_AMOUNT_ERROR("300007", "红包金额错误"),
    RED_PACKET_QUESTION_SAVE_OR_UPDATE_ERROR("300008", "红包问题保存失败"),

    //推广链接
    SPREAD_LINK_SAVE_ERROR("400001", "推广链接保存失败"),

    //指定中奖
    SPECIFY_STOCK_NOT_ENOUGH("500001","指定中奖库存不足"),
    SPECIFY_STOCK_INSERT_ERROR("500002","指定中奖记录插入异常"),
    SPECIFY_AWARD_CONF_INSERT_ERROR("500003","指定中奖配置插入异常"),

    // 小程序码
    BIND_MP_QRCODE_ERROR("600001", "绑定小程序码失败"),

    ;

    private String shortCode;
    private String desc;

    BizErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "06";
    }

    @Override
    public String getShortCode() {
        return this.shortCode;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
