package cn.com.duiba.kjy.livecenter.api.remoteservice.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.FormRecordDto;

import java.util.List;

/**
 * 表单记录rpc服务
 *
 * @author xuzhigang
 * @date 2020/7/27 7:06 下午
 **/
@AdvancedFeignClient
public interface RemoteFormRecordService {

    /**
     * 根据clueRewardId查询表单记录
     *
     * @param clueRewardId 线索奖励领取id （tb_live_clue_reward.id）
     * @return 表单记录集合
     */
    List<FormRecordDto> selectListByClueRewardId(Long clueRewardId);

    /**
     * 根据clueRewardIds查询表单记录
     *
     * @param clueRewardIds 线索奖励领取id集合 （tb_live_clue_reward.id）
     * @return 表单记录集合
     */
    List<FormRecordDto> selectListByClueRewardIds(List<Long> clueRewardIds);

    /**
     * 批量insert
     *
     * @param list 表单记录集合
     * @return 执行结果
     */
    int batchInsertGeneratedKeys(List<FormRecordDto> list);
}
