package cn.com.duiba.kjy.livecenter.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 区域（省）枚举
 * @author lizhi
 * @date 2020/11/11 5:01 下午
 */
@Getter
@AllArgsConstructor
public enum GeoRegionEnum {
    AN_HUI(1, "安徽"),
    AO_MEN(2, "澳门"),
    BEI_JING(3, "北京"),
    CHONG_QING(4, "重庆"),
    FU_JIAN(5, "福建"),
    GAN_SU(6, "甘肃"),
    GUANG_DONG(7, "广东"),
    GUANG_XI(8, "广西"),
    GUI_ZHOU(9, "贵州"),
    HAI_NAN(10, "海南"),
    HEI_LONG_JIANG(11, "黑龙江"),
    HE_BEI(12, "河北"),
    HE_NAN(13, "河南"),
    HU_BEI(14, "湖北"),
    HU_NAN(15, "湖南"),
    JIANG_SU(16, "江苏"),
    JIANG_XI(17, "江西"),
    JI_LIN(18, "吉林"),
    LIAO_NING(19, "辽宁"),
    NEI_MENG_GU(20, "内蒙古"),
    NING_XIA(21, "宁夏"),
    QING_HAI(22, "青海"),
    SHANG_HAI(23, "上海"),
    SHAN_DONG(24, "山东"),
    SHAN_XI(25, "山西"),
    SHAN_XI_2(26, "陕西"),
    SI_CHUAN(27, "四川"),
    TAI_WAN(28, "台湾"),
    TIAN_JIN(29, "天津"),
    XIANG_GANG(30, "香港"),
    XIN_JIANG(31, "新疆"),
    XI_ZANG(32, "西藏"),
    YUN_NAN(33, "云南"),
    ZHE_JIANG(34, "浙江"),
    ;

    /**
     * 区域码
     */
    private final Integer code;

    /**
     * 区域
     */
    private final String region;

    private static final Map<Integer, GeoRegionEnum> ENUM_MAP = new HashMap<>();

    static {
        for (GeoRegionEnum regionEnum : values()) {
            ENUM_MAP.put(regionEnum.getCode(), regionEnum);
        }
    }

    public static GeoRegionEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
