package cn.com.duiba.kjy.livecenter.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.invitation.LiveVisitorInvitationDto;

import java.util.Map;
import java.util.Set;

/**
 * @author zhanghuifeng
 * date 2020/4/4-3:13 下午
 */
@AdvancedFeignClient
public interface RemoteLiveVisitorInvitationService {

    /**
     * 获取用户当前直播间邀请人数（纯缓存，不走DB）
     * @param liveUserId
     * @param liveId
     * @return
     */
    @Deprecated
    long findInviteCountCache(Long liveUserId, Long liveId);

    /**
     * 获取用户当前直播间邀请人数
     * @param liveUserId 邀请人直播用户ID
     * @param liveId 直播ID
     * @return 邀请人数
     */
    long findInviteCount(Long liveUserId, Long liveId);

    /**
     * 根据被邀请人ID查询该用户的被邀请记录
     * @param liveUserId 被邀请人ID
     * @param liveId 直播ID
     * @return 邀请关系
     */
    LiveVisitorInvitationDto selectByLiveUser(Long liveId, Long liveUserId);

    /**
     * 统计邀请人邀请了多少人数
     * @param liveId 直播id
     * @param inviterIds 邀请人id集合
     * @return key：邀请人id value：邀请人邀请的人数
     */
    Map<Long, Long> countInviterHasNum(Long liveId, Set<Long> inviterIds);
}
