package cn.com.duiba.kjy.livecenter.api.remoteservice.open;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.open.LiveClueOpenConfigDto;

/**
 * 直播线索统计-合作方配置
 * @author xuzhigang
 * @date 2020-12-25
 */
@AdvancedFeignClient
public interface RemoteLiveClueOpenConfigService {

    /**
     * 根据公司id查询
     * @param companyId 公司id
     * @return 直播线索统计-合作方配置
     */
    LiveClueOpenConfigDto selectByCompanyId(Long companyId);

    /**
     * 新增
     * @param dto 直播线索统计-合作方配置
     * @return 执行结果
     */
    Long insert(LiveClueOpenConfigDto dto);

    /**
     * 更新
     * @param dto 直播线索统计-合作方配置
     * @return 执行结果
     */
    int update(LiveClueOpenConfigDto dto);
}