package cn.com.duiba.kjy.livecenter.api.util;

import cn.com.duiba.kjy.livecenter.api.dto.third.ThirdMarkApiDto;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 给第三方传输用户信息 加解密工具类
 *
 * @author lizhi
 * @date 2020/4/12 11:50 AM
 */
public class ApiThirdMarkUtils {

    /**
     * 加密盐
     */
    private static final String SHARE_ENCRYPT = "87f2537ff7a3";

    private ApiThirdMarkUtils() {
    }

    /**
     * 平衡加密
     *
     * @param companyId  直播公司ID
     * @param liveUserId 直播用户ID
     * @return 加密串
     */
    public static String encodeMark(Long companyId, Long liveUserId) {
        ThirdMarkApiDto dto = new ThirdMarkApiDto();
        dto.setCompanyId(companyId);
        dto.setLiveUserId(liveUserId);
        return encodeMark(dto);
    }

    /**
     * 平衡加密
     *
     * @param dto 给第三方传输用户信息
     * @return 加密串
     */
    public static String encodeMark(ThirdMarkApiDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        try {
            return BlowfishUtils.encryptBlowfish(JSON.toJSONString(dto), SHARE_ENCRYPT);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 解析分享加密串
     *
     * @param mark 加密串
     * @return 分享参数
     */
    public static ThirdMarkApiDto decodeMark(String mark) {
        if (StringUtils.isBlank(mark) || "undefined".equals(mark) || StringUtils.equals(mark, "null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish(mark, SHARE_ENCRYPT);
            JSONObject jsonObject = JSON.parseObject(content);
            ThirdMarkApiDto dto = jsonObject.toJavaObject(ThirdMarkApiDto.class);
            if (dto == null) {
                return null;
            }
            return dto;
        } catch (Exception e) {
            return null;
        }
    }

}
