package cn.com.duiba.kjy.livecenter.api.dto.statistics;

import lombok.Data;

import java.io.Serializable;

/**
 * @author 吴文哲
 * @date 2020/11/28 3:36 下午
 **/
@Data
public class LiveTeamRankDto implements Serializable {
    private static final long serialVersionUID = 2938071494814821864L;

    /**
     * 团队id
     */
    private Long teamId;

    /**
     * 团队名称
     */
    private String teamName;

    /**
     * 排名
     */
    private int ranking;

    /**
     * 邀请数
     */
    private int invitationNum;

    /**
     * 到场数
     */
    private int presentNum;

    /**
     * 平均邀请数: 精确到小数点后两位
     */
    private double avgInviteNum;

    /**
     * 平均到场数: 精确到小数点后两位
     */
    private double avgPresentNum;

    /**
     * 直播间状态
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveStatusApiEnum
     */
    private Integer liveStatus;

    /**
     * 成员数  只有展示自己所在团队的时候才有这个值
     */
    private Integer memberNum;
}
