package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveClueChoiceQuestionDto;

import java.util.List;

/**
 * 测一测访客线索
 * @author lizhi
 * @date 2020/5/19 10:56 AM
 */
@AdvancedFeignClient
public interface RemoteLiveClueChoiceQuestionService {

    /**
     * 查询问题ID对应线索最大的主键
     * @param choiceQuestionId 选择题问题ID，tb_choice_question.id
     * @return 问题ID对应线索最大的主键
     */
    Long selectMaxId(Long choiceQuestionId);

    /**
     * 批量新增选择题 答题线索
     * @param clueChoiceQuestionDtoList
     * @return
     */
    int batchInsert(Long liveId,List<LiveClueChoiceQuestionDto> clueChoiceQuestionDtoList);

    /**
     * 查询已经回答过的用户
     * 用户排除掉已经作答的用户的提交
     * @param liveId
     * @param questionId
     * @param liveUserIds
     * @return
     */
    List<Long> findLiveUserIdByLiveIdAndQuestionId(Long liveId,Long questionId,List<Long> liveUserIds);
}
