package cn.com.duiba.kjy.livecenter.api.dto.invitation;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2021/1/8 2:56 下午
 */
@Data
public class BindingResultDto implements Serializable {

    private static final long serialVersionUID = -3275196154682743830L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 邀请人id
     */
    private Long inviterId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 绑定的代理人ID
     */
    private Long agentId;

    /**
     * 绑定时的直播间状态
     */
    private Integer liveStatus;

    /**
     * 是否直接邀请
     * 1：直接邀请（代理人邀请） 0：间接邀请（访客邀请）
     * @see cn.com.duiba.live.clue.service.api.enums.clue.AgentDirectlyEnum
     */
    private Integer directly;


    /**
     * 是否到场：0-未到场，1-已到场
     */
    private Integer present;
}
