package cn.com.duiba.kjy.livecenter.api.enums.clue;

import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.List;

/**
 * 直播线索价值类型
 * @author 吴文哲
 * @date 2020-09-22 12:02
 **/
@Getter
public enum LiveClueValueEnums {

    HIGH_VALUE(3,"高价值：包含中奖、报名、观看30分钟+"),
    MEDIUM_VALUE(2,"中等福利:免费领福利、领取资料、咨询、观看20分钟+"),
    NORMAL_VALUE(1,"普通价值:没有中价值行为"),

    ;

    /**
     * 高价值行为列表
     */
    public static final List<Integer> HIGH_VALUE_ACTION_TYPES = Lists.newArrayList();

    /**
     * 中价值行为列表
     */
    public static final List<Integer> MEDIUM_VALUE_ACTION_TYPES = Lists.newArrayList();

    static {
        //LiveVisitorActionEnums.AWARD
        HIGH_VALUE_ACTION_TYPES.add(17);
        //LiveVisitorActionEnums.SUBMIT
        HIGH_VALUE_ACTION_TYPES.add(20);
        //LiveVisitorActionEnums.READ_DURATION_OVER_30
        HIGH_VALUE_ACTION_TYPES.add(5);
        //LiveVisitorActionEnums.RECEIVE_TICKETS(27,"领取增员门票")
        HIGH_VALUE_ACTION_TYPES.add(27);

        //LiveVisitorActionEnums.FREE_AWARD
        MEDIUM_VALUE_ACTION_TYPES.add(18);
        //LiveVisitorActionEnums.RESOURCE
        MEDIUM_VALUE_ACTION_TYPES.add(19);
        //LiveVisitorActionEnums.ADVISORY
        MEDIUM_VALUE_ACTION_TYPES.add(21);
        //LiveVisitorActionEnums.READ_DURATION_FROM_20_TO_30
        MEDIUM_VALUE_ACTION_TYPES.add(4);
        //LiveVisitorActionEnums.READ_DURATION_OVER_30
        MEDIUM_VALUE_ACTION_TYPES.add(5);
    }

    /**
     * 价值类型
     */
    private Integer valueType;

    /**
     * 描述
     */
    private String desc;

    LiveClueValueEnums(Integer valueType,String desc){
        this.valueType = valueType;
        this.desc = desc;
    }


}
