package cn.com.duiba.kjy.livecenter.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.customer.EsAgentCustomerDto;
import cn.com.duiba.kjy.livecenter.api.param.customer.EsAgentCustomerSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 客户维度-代理人客户相关统计
 *
 * @author ZhangJun
 * @date 2021/7/1 9:41 下午
 */
@AdvancedFeignClient
public interface RemoteAgentCustomerEsService {

    /**
     * 根据微信昵称或手机号分页查询客户列表
     *
     * @param param 查询条件
     * @return 客户列表，key：符合条件的结果总数，value：当前分页查询到的结果集
     */
    Pair<Long, List<EsAgentCustomerDto>> searchCustomerList(EsAgentCustomerSearchParam param);

    /**
     * 查询客户信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @return 查询到的客户信息
     */
    EsAgentCustomerDto searchCustomerById(Long agentId, Long customerId);

}
