package cn.com.duiba.kjy.livecenter.api.param.clue;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 直播权益领取查询参数
 * @author 吴文哲
 * @date 2020-04-05 15:04
 **/
@Data
public class LiveClueRewardParam4Task implements Serializable {
    private static final long serialVersionUID = -5571791039991001945L;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 访客id列表
     */
    private List<Long> liveUserIds;

    /**
     * 奖励类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.clue.LiveClueRewardTypeEnums
     */
    private Integer rewardType;

    /**
     * 奖励类型列表
     */
    private List<Integer> rewardTypes;

    /**----------以下条件查线索详情时使用-------**/
    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 用户id
     */
    private Long liveUserId;

}
