package cn.com.duiba.kjy.livecenter.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.agent.LiveAgentClueNumApiDto;
import cn.com.duiba.kjy.livecenter.api.dto.statistics.LiveHighQualityClueDto;
import cn.com.duiba.kjy.livecenter.api.dto.user.OutLiveStatisticUserDto;
import cn.com.duiba.kjy.livecenter.api.dto.user.OuterLiveUserClueDto;
import cn.com.duiba.live.statistics.service.api.dto.user.LiveStatisticsUserDto;
import cn.com.duiba.live.statistics.service.api.dto.user.OutLiveStatisticUserReadDto;
import cn.com.duiba.live.statistics.service.api.param.clue.LiveClueQueryParam;
import cn.com.duiba.live.statistics.service.api.param.user.LiveStatisticsUserSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 直播用户统计rpc服务接口
 *
 * @author xuzhigang
 * @date 2020-09-02 16:04
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticUserService {

    /**
     * 获取优质线索列表
     *
     * @param liveId 直播id
     * @param visitorLiveUserId 访客直播用户id
     * @param sellerLiveUserId 客集集代理人对应直播用户id
     * @return 优质线索集合
     */
    List<LiveHighQualityClueDto> getHighQualityClue(Long liveId, Long visitorLiveUserId, Long sellerLiveUserId);

    /**
     * 获取用户参与的线索类型列表
     *
     * @param liveId 直播id
     * @param visitorLiveUserId 访客直播用户id
     * @param sellerLiveUserId 客集集代理人对应直播用户id
     * @return 线索类型列表
     */
    List<Integer> getClueTypeList(Long liveId, Long visitorLiveUserId, Long sellerLiveUserId);

    /**
     * 获取用户参与的线索类型列表
     *
     * @param liveId 直播id
     * @param liveVisitorIds 访客直播用户id列表
     * @param agentLiveUserId 客集集代理人对应直播用户id
     * @return key: 客户直播间用户id val:线索类型列表
     */
    Map<Long, Set<Integer>> getLiveUserId2ClueTypeListMap(Long liveId, List<Long> liveVisitorIds, Long agentLiveUserId);


    /**
     * 根据条件查询用户统计信息列表
     *
     * @param param
     * @return
     */
    List<OutLiveStatisticUserDto> findStatisticUserByConditionV2(LiveClueQueryParam param);


    /**
     * 根据条件统计用户信息数量
     *
     * @param param
     * @return
     */
    Integer countStatisticUserByConditionV2(LiveClueQueryParam param);


    /**
     * 获取线索详情
     *
     * @param liveId            直播间id
     * @param visitorliveUserId 访客直播用户Id
     * @param sellerLiveUserId  客集集代理人对应直播用户id
     * @return
     */
    OuterLiveUserClueDto getClueDetail(Long liveId, Long visitorliveUserId, Long sellerLiveUserId);

    /**
     * 根据唯一索引查询已读标识信息
     * @param liveId 直播id
     * @param agentId 直播代理人id
     * @param userId 访客直播用户id
     * @return 已读标识信息
     */
    OutLiveStatisticUserReadDto findReadByUnique(Long liveId, Long agentId, Long userId);

    /**
     * 根据主键id将线索标记为已读
     * @param id 主键id
     * @return 执行结果
     */
    int readClueById(Long id);

    /**
     * 计算代理人线索数
     * @return
     */
    LiveAgentClueNumApiDto countAgentClueNumV2(Long liveId, Long agentId);

    /**
     * 批量查询用户观看时长
     *
     * @param liveIds  直播id
     * @param agentId  代理人id
     * @param userId 用户id
     * @return 观看时长，key:liveId, value:duration
     */
    Map<Long, Integer> findDurationsMapByLiveId(List<Long> liveIds, Long agentId, Long userId);

    /**
     * 根据条件查询 支持分页，按照线索得分倒序排列
     *
     * @param param
     * @return
     */
    List<LiveStatisticsUserDto> findByConditionOrderByScore(LiveStatisticsUserSearchParam param);
}
