/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.enums.user;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum UserRoleEnum {
    VISITOR(0, "\u8bbf\u5ba2"),
    AGENT(1, "\u4ee3\u7406\u4eba");

    private Integer roleType;
    private String desc;
    private static final Map<Integer, UserRoleEnum> ENUM_MAP;

    public static UserRoleEnum getByType(Integer roleType) {
        if (roleType == null) {
            return null;
        }
        return ENUM_MAP.get(roleType);
    }

    public Integer getRoleType() {
        return this.roleType;
    }

    public String getDesc() {
        return this.desc;
    }

    private UserRoleEnum(Integer roleType, String desc) {
        this.roleType = roleType;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(UserRoleEnum.values()).collect(Collectors.toMap(UserRoleEnum::getRoleType, Function.identity())));
    }
}

