package cn.com.duiba.kjy.livecenter.api.dto.open;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播线索统计-合作方代理人客户信息
 * @author kjj mybatis generator 
 * @date 2020-12-25
 */
@Data
public class LiveClueOpenUserDto implements Serializable {
     
    private static final long serialVersionUID = 16088612949929446L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代理人id tb_live_agent.id
     */
    private Long agentId;

    /**
     * 客户用户id tb_live_user.id
     */
    private Long liveUserId;

    /**
     * 手机号
     */
    private String authPhoneNum;

    /**
     * 微信昵称
     */
    private String wechatNickname;

    /**
     * 微信头像
     */
    private String wechatAvatar;

    /**
     * 用户所在国家
     */
    private String userCountry;

    /**
     * 用户所在省
     */
    private String userProvince;

    /**
     * 用户所在市
     */
    private String userCity;

    /**
     * 根据线索得分计算的线索等级 1-普通价值 2-中价值 3-高价值
     */
    private Integer clueLevel;

    /**
     * 是否到场：0-未到场，1-已到场
     */
    private Integer present;

    /**
     * 是否直接邀请 0-间接邀请，1-直接邀请
     */
    private Integer directly;

    /**
     * 累计观看时长
     */
    private Integer watchDuration;

    /**
     * 是否关注  0:未关注 1:关注
     */
    private Integer subscribe;

    /**
     * 邀请链路 live_user_id按，分割
     */
    private String inviteRouter;

    /**
     * openId
     */
    private String openId;

    /**
     * unionId
     */
    private String unionId;
}