package cn.com.duiba.kjy.livecenter.api.dto.open;

import lombok.Data;

import java.io.Serializable;

/**
 * 第三方配置
 *
 * @author xuzhigang
 * @date 2022/1/18 4:07 下午
 **/
@Data
public class OpenConfigDto implements Serializable {
    private static final long serialVersionUID = 6007197613444299426L;

    /**
     * 配置id
     */
    private Long id;

    /**
     * 公钥
     */
    private String accessKey;

    /**
     * 秘钥
     */
    private String accessSecret;

    /**
     * 企业版公司id
     */
    private Long corpCompanyId;

    /**
     * 直播总公司id
     */
    private Long liveFirstCompanyId;

    /**
     * 集客助手公司id
     */
    private Long kjjCompanyId;

    /**
     * 公众号id
     */
    private Long oaId;

    /**
     * 线索推送链接
     */
    private String cluePushUrl;

    /**
     * 客户信息推送链接
     */
    private String customerPushUrl;

    /**
     * 企业id
     */
    private Long corpId;

    /**
     * 应用id
     */
    private Long suiteId;

    /**
     * 公司枚举值 针对不同公司做定制需求时可以配置，没有定制需求时没有也没关系
     * {@link cn.com.duiba.kjy.livecenter.api.enums.open.OpenCompanyEnum}
     */
    private Integer openCompanyCode;

    /**
     * 备注
     */
    private String remark;
}
