package cn.com.duiba.kjy.livecenter.api.enums.open;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 第三方合作公司枚举
 *
 * @author xuzhigang
 * @date 2022/4/19 10:03 上午
 **/
@Getter
@AllArgsConstructor
public enum OpenCompanyEnum {
    TEST(1, "测试公司"),
    MANULIFE_UAT(2, "中宏uat环境"),
    MANULIFE_PROD(3, "中宏生产环境"),
    ;

    private final Integer code;

    private final String desc;

    private static final Map<Integer, OpenCompanyEnum> map = new HashMap<>();

    static {
        for (OpenCompanyEnum value : values()) {
            map.put(value.getCode(), value);
        }
    }

    public static OpenCompanyEnum getByCode(Integer code) {
        return map.get(code);
    }
}
