package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveAgentInvitationBizDto;
import cn.com.duiba.live.clue.service.api.dto.invitation.LiveAgentInvitationDto;
import cn.com.duiba.live.clue.service.api.param.invitation.LiveAgentInvitationSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 邀请客户服务类
 * @author 吴文哲
 * @date 2020-03-30 19:52
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentInvitationService {

    /**
     * 获取被邀请人的列表
     * @param param
     * @return
     */
    List<LiveAgentInvitationDto> getInvitedUserList(LiveAgentInvitationSearchParam param);

    /**
     * 统计被邀请人数
     * @param param
     * @return
     */
    Integer countInvitedUser(LiveAgentInvitationSearchParam param);

    /**
     * 查询被邀请人代理人ID
     * @param liveId 直播ID
     * @param visitorId 被邀请人用户ID
     * @return 被邀请人代理人ID
     */
    Long findAgentByLiveAndVisitorId(Long liveId, Long visitorId);

    /**
     * 查找用户绑定代理人ID
     * @param liveId 直播ID
     * @param liveVisitorIdList 直播用户ID集合
     * @return key：直播用户ID，value：绑定代理人ID
     */
    Map<Long, Long> findInvitationAgentIdMap(Long liveId, List<Long> liveVisitorIdList);

    /**
     * 查询被邀请人代理人ID
     * @param liveId 直播ID
     * @param bizUserId 被邀请人业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @return 邀请关系
     */
    LiveAgentInvitationBizDto findAgentByLiveAndBizUserIdAnType(Long liveId, String bizUserId, Integer bizType);

    /**
     * 查询直播ID对应绑定代理人人数
     * @param liveIdList 直播ID集合
     * @return key：直播ID，value：绑定代理人人数
     */
    Map<Long, Long> getLiveAgentInvitationNum(List<Long> liveIdList);

    /**
     * 获取当前用户绑定代理人ID
     * @param liveId 直播ID
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @return 绑定代理人ID
     */
    Long findInvitationAgentIdByBiz(Long liveId, String bizUserId, Integer bizType);

    /**
     * 获取代理人邀请人数
     * @param liveId 直播id
     * @param agentIds 直播代理人id集合
     * @param directly 是否直接邀请（非必传）: 0-间接邀请，1-直接邀请
     * @return key：代理人id value：代理人邀请人数
     */
    Map<Long, Long> countAgentInviteNum(Long liveId, Set<Long> agentIds, Integer directly);
}
