package cn.com.duiba.kjy.livecenter.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.customer.EsAgentCustomerDto;
import cn.com.duiba.kjy.livecenter.api.dto.customer.EsAgentCustomerStatDto;
import cn.com.duiba.kjy.livecenter.api.param.customer.EsAgentCustomerSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 客户维度-代理人客户相关统计
 *
 * @author ZhangJun
 * @date 2021/7/1 9:41 下午
 */
@AdvancedFeignClient
public interface RemoteAgentCustomerEsService {

    /**
     * 根据微信昵称或手机号分页查询客户列表
     *
     * @param param 查询条件
     * @return 客户列表，key：符合条件的结果总数，value：当前分页查询到的结果集
     */
    Pair<Long, List<EsAgentCustomerDto>> searchCustomerList(EsAgentCustomerSearchParam param);

    /**
     * 查询客户信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @return 查询到的客户信息
     */
    EsAgentCustomerDto searchCustomerById(Long agentId, Long customerId);

    /**
     * 批量查询客户信息
     *
     * @param agentId    代理人id
     * @param customerIds 客户id集合
     * @return 查询到的客户信息集合，
     */
    List<EsAgentCustomerDto> searchCustomerByIds(Long agentId, List<Long> customerIds);

    /**
     * 根据条件统计es中的数据
     * @param param 统计参数
     * @return 统计结果
     */
    Long countByCondition(EsAgentCustomerSearchParam param);

    /**
     * 获取代理人客户管理统计信息
     * @param agentId 代理人id
     * @return 代理人客户统计信息
     */
    EsAgentCustomerStatDto getCustomerStatFromRedis(Long agentId);

}
