package cn.com.duiba.kjy.livecenter.api.remoteservice.open;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.open.LiveClueOpenUserDto;
import cn.com.duiba.kjy.livecenter.api.dto.open.LiveClueOpenUserSimpleDto;
import cn.com.duiba.kjy.livecenter.api.param.open.LiveClueOpenUserSearchParam;

import java.util.List;

/**
 * 直播线索统计-合作方代理人客户信息
 * @author kjj mybatis generator 
 * @date 2020-12-25
 */
@AdvancedFeignClient
public interface RemoteLiveClueOpenUserService {
     
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播线索统计-合作方代理人客户信息集合
     */
    List<LiveClueOpenUserDto> selectListPage(LiveClueOpenUserSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveClueOpenUserSearchParam param);

    /**
     * 瀑布流查询
     * @param liveId 直播id
     * @param agentId 代理人id
     * @param lastId 上次最大id
     * @param pageSize 每次查询数据量
     * @return 直播线索统计-合作方代理人客户信息集合
     */
    List<LiveClueOpenUserDto> selectListWaterFall(Long liveId, Long agentId, Long lastId, Integer pageSize);

    /**
     * 根据直播id和用户id查询用户信息
     *
     * @param liveId 直播id
     * @param liveUserIds 用户id
     * @return 用户信息
     */
    List<LiveClueOpenUserSimpleDto> selectByLiveIdAndLiveUserIds(Long liveId, List<Long> liveUserIds);

    /**
     * 瀑布流查询用户信息
     *
     * @param liveId 直播id
     * @param startLiveUserId 起始用户id
     * @param pageSize 每页大小
     * @return 用户信息
     */
    List<LiveClueOpenUserSimpleDto> selectByLiveIdPage(Long liveId, Long startLiveUserId, Integer pageSize);
}