package cn.com.duiba.kjy.livecenter.api.remoteservice.open.cinga;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.open.cinga.CingaContentDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2022/4/24 6:02 下午
 **/
@AdvancedFeignClient
public interface RemoteCingaContentService {
    /**
     * 根据日期批量查询
     *
     * @param startDate 起始日期
     * @param endDate 结束日期
     * @param lastId 上次最大id
     * @param pageSize 每次查询数量
     * @return 招商信诺内容集合
     */
    List<CingaContentDto> selectList(String startDate, String endDate, Long lastId, Integer pageSize);

    /**
     * 批量新增或更新
     * @param list 招商信诺内容
     * @return 执行结果
     */
    int batchSaveOrUpdate(List<CingaContentDto> list);
}
