package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.UserInfo4LoginDto;
import cn.com.duiba.kjy.livecenter.api.param.SyncUserParam;

/**
 * Created by dugq on 2020-03-31.
 */
@AdvancedFeignClient
public interface RemoteOutLiveUserService {

    /**
     * 同步第三方用户信息，并返回直播系统用户信息
     * @param param 第三方用户信息
     * @return 本系统用户信息
     */
    UserInfo4LoginDto getAndSyncUser(SyncUserParam param);

    /**
     * 根据三方业务id 业务类型获取 直播系统用户id
     * @param bizUserId 三方业务用户id
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     * @return  加密的客集集直播系统用户id
     */
    String getLiveUserIdByBizUserIdAndType(String bizUserId,Integer bizType);

}
