package cn.com.duiba.kjy.livecenter.api.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 查询接口返回的直播间信息
 * @author 吴文哲
 * @date 2020-04-07 19:47
 **/
@Data
public class LiveVo implements Serializable {
    private static final long serialVersionUID = 5919383159697751421L;

    /**
     * 加密的直播ID
     */
    private Long liveId;

    /**
     * 直播状态：
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveStatusEnum
     */
    private Integer liveStatus;

    /**
     * 直播开始时间
     */
    private Date startTime;

    /**
     * 直播结束时间
     */
    private Date endTime;

    /**
     * 直播列表图片
     */
    private String picUrl;

    /**
     * 直播标题
     */
    private String title;
}
