package cn.com.duiba.kjy.livecenter.api.enums.live;

import java.util.HashMap;
import java.util.Map;

/**
 * 直播状态
 * @author lizhi
 * @date 2020/3/30 3:27 PM
 */
public enum LiveStatusEnum {
    LIVE_NOTICE(1, "未开始"),
    LIVE_PROCESSING(2, "直播中"),
    LIVE_INTERRUPT(3, "断网"),
    LIVE_END(4, "直播结束"),
    ;

    private Integer code;

    private String desc;

    LiveStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, LiveStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LiveStatusEnum statusEnum : values()){
            ENUM_MAP.put(statusEnum.getCode(), statusEnum);
        }
    }

    public static LiveStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
