package cn.com.duiba.kjy.livecenter.api.param.clue;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 线索查询参数
 * @author 吴文哲
 * @date 2020-04-08 13:46
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class OutLiveClueQueryParam extends PageQuery implements Serializable {


    private static final long serialVersionUID = 6373467246395966161L;
    /**
     * 线索类型  是否领权益: 0-否,1-是
     */
    private Integer welfareType;

    /**
     * 线索类型  是否领资料: 0-否,1-是
     */
    private Integer resourceType;

    /**
     * 线索类型  是否提问题: 0-否,1-是
     */
    private Integer questionType;


    /**
     * 测一测类型 : 0-否,1-是
     */
    private Integer choiceQuestionType;

    /**
     * 咨询类型 是否有咨询: 0-否,1-是
     */
    private Integer adviceType;

    /**
     * 客集集会员在直播平台的用户id
     */
    private Long liveUserId;

    /**
     * 直播间id
     */
    private Long liveId;


}
