package cn.com.duiba.kjy.livecenter.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.agent.LiveAgentAdviceInfoDto;
import cn.com.duiba.kjy.livecenter.api.dto.agent.LiveAgentInfoDto;

import java.util.List;

/**
 * 直播代理人相关
 * @author lizhi
 * @date 2020/6/7 10:19 AM
 */
@AdvancedFeignClient
public interface RemoteOutLiveAgentService {

    /**
     * 根据主键获取代理人信息（包含公司和团队信息）
     * @param id 主键
     * @return 代理人信息
     */
    LiveAgentInfoDto findInfoById(Long id);

    /**
     * 批量查询代理人信息（包含公司和团队信息）
     * @param ids 主键集合
     * @return 代理人信息
     */
    List<LiveAgentInfoDto> findInfoByIds(List<Long> ids);

    /**
     * 批量查询代理人信息（用于业务咨询）
     * @param ids 主键集合
     * @return 代理人信息
     */
    List<LiveAgentAdviceInfoDto> findAdviceInfoByIds(List<Long> ids);
}
