package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.LiveAgentClueNumDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.OutLiveClueQueryParam;
import cn.com.duiba.kjy.livecenter.api.vo.OutLiveStatisticUserReadVo;
import cn.com.duiba.kjy.livecenter.api.vo.OutLiveStatisticUserVo;
import cn.com.duiba.kjy.livecenter.api.vo.OuterLiveUserClueVo;

import java.util.List;

/**
 * 直播用户统计rpc服务接口
 *
 * @author 吴文哲
 * @date 2020-04-08 13:44
 **/
@AdvancedFeignClient
public interface RemoteOutLiveStatisticUserService {

    /**
     * 根据条件查询用户统计信息列表
     *
     * @param param
     * @return
     */
    List<OutLiveStatisticUserVo> findStatisticUserByCondition(OutLiveClueQueryParam param);

    /**
     * 根据条件统计用户信息数量
     *
     * @param param
     * @return
     */
    Integer countStatisticUserByCondition(OutLiveClueQueryParam param);


    /**
     * 获取线索详情
     *
     * @param liveId            直播间id
     * @param visitorliveUserId 访客直播用户Id
     * @param sellerLiveUserId  客集集代理人对应直播用户id
     * @return
     */
    OuterLiveUserClueVo getClueDetail(Long liveId, Long visitorliveUserId, Long sellerLiveUserId);

    /**
     * 根据唯一索引查询已读标识信息
     * @param liveId 直播id
     * @param agentId 直播代理人id
     * @param userId 访客直播用户id
     * @return 已读标识信息
     */
    OutLiveStatisticUserReadVo findReadByUnique(Long liveId, Long agentId, Long userId);

    /**
     * 根据主键id将线索标记为已读
     * @param id 主键id
     * @return 执行结果
     */
    int readClueById(Long id);

    /**
     * 计算代理人线索数
     * @return
     */
    LiveAgentClueNumDto countAgentClueNum(Long liveId, Long agentId);
}
