package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.LiveInfoDto;
import cn.com.duiba.kjy.livecenter.api.vo.LiveVo;

import java.util.List;

/**
 * 直播rpc服务
 * @author 吴文哲
 * @date 2020-04-06 10:02
 **/
@AdvancedFeignClient
@Deprecated
public interface RemoteOutLiveService {

    /**
     * 根据liveId 查找公司Id
     * @param liveId
     * @return
     */
    Long findCompanyIdByLiveId(Long liveId);

    /**
     * 根据用户Id 查询直播间列表
     * 查代理人所在公司的直播列表
     * @param liveUserId 直播系统用户id
     * @return
     */
    List<LiveVo> findListListByLiveUserId4Kjj(Long liveUserId, Integer pageIndex, Integer pageSize);

    /**
     * 查询未结束的最近一场直播的直播信息
     * @param companyId 公司id
     * @return 直播信息
     */
    LiveInfoDto findNotOverLiveIdsByCompanyId(Long companyId);
}
