/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.paycenter.api.enums;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum ChannelTypeEnum {
    WX_PUB("wx_pub", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8"),
    WX_LITE("wx_lite", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8");

    private String channelType;
    private String channelName;
    private static final Map<String, ChannelTypeEnum> ENUM_MAP;

    private ChannelTypeEnum(String channelType, String channelName) {
        this.channelType = channelType;
        this.channelName = channelName;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public static ChannelTypeEnum getByChannelType(String channelType) {
        if (channelType == null) {
            return null;
        }
        return ENUM_MAP.get(channelType);
    }

    public static boolean isActive(String channelType) {
        if (StringUtils.isBlank((String)channelType)) {
            return false;
        }
        return ChannelTypeEnum.getByChannelType(channelType) != null;
    }

    static {
        ENUM_MAP = new HashMap<String, ChannelTypeEnum>();
        for (ChannelTypeEnum typeEnum : ChannelTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getChannelType(), typeEnum);
        }
    }
}

