/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.paycenter.api.validator;

import cn.com.duiba.kjy.paycenter.api.annotation.MinExpireTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MinExpireTimeConstraintValidator
implements ConstraintValidator<MinExpireTime, Date> {
    private static final int FIVE_MINUTES = 5;
    private String message;

    public void initialize(MinExpireTime constraintAnnotation) {
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Date date, ConstraintValidatorContext context) {
        if (date == null) {
            return true;
        }
        if (LocalDateTime.now().plus(5L, ChronoUnit.MINUTES).isBefore(date.toInstant().atZone(ZoneId.of("GMT+08:00")).toLocalDateTime())) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(this.message);
        builder.addConstraintViolation();
        return false;
    }
}

