package cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay;

import cn.com.duiba.kjy.paycenter.api.enums.ResponseCodeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 微信企业付款到零钱相应结果
 * @author lizhi
 * @date 2020/4/1 5:09 PM
 */
@Data
public class WxPayCompanyResponse implements Serializable {

    private static final long serialVersionUID = -5840823227527133602L;

    /**
     * 返回状态码（SUCCESS/FAIL）
     * 成功时，需要再次校验resultCode
     */
    private String code;

    /**
     * 错误信息描述
     */
    private String message;

    //以下参数在code为SUCCESS时，才有值

    /**
     * 0-初始化状态,1-调用微信发生错误,2-微信中间状态，具体根据错误码来处理,3-转账成功,4-转账失败
     * 注意：调用微信发生错误，或者中间状态、失败状态，重试的时候，一定不要换单号
     * @see cn.com.duiba.kjy.paycenter.api.enums.wxpay.WxPayCompanyPayStatusEnum
     */
    private Integer payStatus;

    /**
     * 错误码信息，注意：出现未明确的错误码时（SYSTEMERROR等），请务必用原商户订单号重试，或通过查询接口确认此次付款的结果。
     * 因为错误代码字段err_code的值后续可能会增加，所以商户如果遇到回包返回新的错误码，请商户务必不要换单重试，请商户联系客服确认付款情况。如果有新的错误码，会更新到此API文档中。
     * 具体错误码，见微信文档：https://pay.weixin.qq.com/wiki/doc/api/tools/mch_pay.php?chapter=14_2
     */
    private String errCode;

    /**
     * 错误代码描述
     * 错误代码描述字段err_code_des只供人工定位问题时做参考，系统实现时请不要依赖这个字段来做自动化处理。
     */
    private String errCodeDes;

    /**
     * 商户订单号
     */
    private String partnerTradeNo;

    /**
     * 企业付款成功，返回的微信付款单号，成功时有值
     */
    private String paymentNo;

    /**
     * 企业付款成功时间，成功时有值
     */
    private String paymentTime;

    public static WxPayCompanyResponse buildErrorMsg(WxPayCompanyResponse response, String errorMsg) {
        if (response == null) {
            return null;
        }
        response.setCode(ResponseCodeEnum.FAIL.getCode());
        response.setMessage(errorMsg);
        return response;
    }
}
