package cn.com.duiba.kjy.paycenter.api.enums;

import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 支付渠道枚举
 * @author lizhi
 * @date 2020/2/28 11:42 AM
 */
public enum ChannelTypeEnum {

    /**
     * 微信公众号支付
     */
    WX_PUB("wx_pub", "微信公众号支付"),

    /**
     * 微信小程序支付
     */
    WX_LITE("wx_lite", "微信小程序支付"),


    /**
     * 支付宝手机网站支付2.0
     */
    ALIPAY_WAP_PAY("alipay_wap_pay","支付宝手机网站支付2.0")

    ;

    private String channelType;
    private String channelName;

    ChannelTypeEnum(String channelType, String channelName) {
        this.channelType = channelType;
        this.channelName = channelName;
    }

    public String getChannelType() {
        return channelType;
    }

    public String getChannelName() {
        return channelName;
    }

    private static final Map<String, ChannelTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ChannelTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getChannelType(), typeEnum);
        }
    }

    public static ChannelTypeEnum getByChannelType(String channelType) {
        if (channelType == null) {
            return null;
        }
        return ENUM_MAP.get(channelType);
    }

    /**
     * 返回channelType是否有效
     * @param channelType 渠道
     * @return 是否有效
     */
    public static boolean isActive(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return false;
        }
        return getByChannelType(channelType) != null;
    }
}
