package cn.com.duiba.kjy.paycenter.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.pay.RefundOrderDto;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.BaseRefundRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.BaseRefundResponse;

import java.util.List;

/**
 * 退款相关
 * @author lizhi
 * @date 2020/3/3 2:15 PM
 */
@AdvancedFeignClient
public interface RemoteRefundService {

    /**
     * 微信退款异步接口
     * 返回成功只是提交成功
     *
     * @param refundRequest 退款请求
     * @return 微信退款请求响应
     * @throws BizException bizException
     */
    BaseRefundResponse refund(BaseRefundRequest refundRequest) throws BizException;

    /**
     * 通过商户退款单号查找退款订单流水
     * @param outRefundNo 珊瑚退款单号
     * @return  退款流水
     */
    RefundOrderDto findByOutRefundNo(String outRefundNo) throws BizException;

    /**
     * 通过业务方类型和退款单号查找退款订单流水
     * @param bizRefundNo 业务方的退款订单id
     * @param bizType 业务方类型
     * @return  退款流水
     */
    RefundOrderDto findByBizRefundNoAndBizType(String bizRefundNo, Integer bizType) throws BizException;

    /**
     * 根据第三方交易流水号查询该订单对应的所有退款单（最多100条）
     * @param transactionNo 第三方交易流水号
     * @return 退款流水集合
     */
    List<RefundOrderDto> findByTransactionNo(String transactionNo) throws BizException;
}
