package cn.com.duiba.kjy.paycenter.api.enums.wxpay;

/**
 * 微信交易状态
 * @author lizhi
 * @date 2020/3/2 4:41 PM
 */
public enum WxPayTradeStateEnum {

    /**
     * 支付成功
     */
    SUCCESS,
    /**
     * 转入退款
     */
    REFUND,
    /**
     * 未支付
     */
    NOTPAY,
    /**
     * 已关闭
     */
    CLOSED,
    /**
     * 已撤销（付款码支付）
     */
    REVOKED,
    /**
     * 用户支付中（付款码支付）
     */
    USERPAYING,
    /**
     * 支付失败(其他原因，如银行返回失败)
     */
    PAYERROR,
    ;
}
