package cn.com.duiba.kjy.paycenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayCompanyQueryRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayCompanyRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayCompanyResponse;
import cn.com.duiba.kjy.paycenter.api.dto.wxpay.WxPayCompanyOrderDto;

/**
 * 微信企业付款到零钱
 * @author lizhi
 * @date 2020/4/1 3:09 PM
 */
@AdvancedFeignClient
public interface RemoteWxPayCompanyService {

    //文档地址：https://pay.weixin.qq.com/wiki/doc/api/tools/mch_pay.php?chapter=14_2

    /**
     * 微信企业付款到零钱
     * @param request 付款参数
     * @return 结果
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="3000")
    WxPayCompanyResponse companyPay(WxPayCompanyRequest request);

    /**
     * 微信企业付款到零钱查询接口
     * @param request 查询参数
     * @return 结果
     */
    WxPayCompanyOrderDto companyQuery(WxPayCompanyQueryRequest request);
}
