package cn.com.duiba.kjy.paycenter.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/5 3:31 PM
 */
public enum CallbackTypeEnum {

    /**
     * 支付回调
     */
    CHARGE(1),

    /**
     * 退款回调
     */
    REFUND(2),

    /**
     * 企业付款到领取结果
     */
    WX_COM_RESULT(3),
    ;

    private Integer code;

    CallbackTypeEnum(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, CallbackTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CallbackTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static CallbackTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
