package cn.com.duiba.kjy.paycenter.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 订单同步对象
 * @author 吴文哲
 * @date 2021/8/12 11:29 上午
 **/
@Data
public class OrderSyncDto implements Serializable {
    private static final long serialVersionUID = -3573963889829138731L;

    /**
     * 业务订单号列表
     */
    private List<String> bizOrderNoList;

    /**
     * 业务类型
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    private Integer bizType;

    /**
     * 通知对应的topic
     */
    private String topic;

    /**
     * 通知对应的tag
     */
    private String tag;
}
