package cn.com.duiba.kjy.paycenter.api.param.alipay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 *
 * 订单过滤参数
 * @author 吴文哲
 * @date 2020-07-10 14:17
 **/
@Data
public class ChargeOrderFilterParam implements Serializable {
    private static final long serialVersionUID = -3044973215330979193L;

    /**
     * 支付中心分配的业务方类型
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    private Integer bizType;

    /**
     * 支付订单状态
     * @see cn.com.duiba.kjy.paycenter.api.enums.ChargeOrderStatusEnum
     */
    private Integer chargeStatus;

    /**
     * 支付订单状态列表
     */
    private List<Integer> statusList;

    /**
     * 交易超时 开始时间
     */
    private Date startExpireTime;

    /**
     * 交易超时 结束时间
     */
    private Date endExpireTime;

    /**
     * 渠道类型枚举
     * @see cn.com.duiba.kjy.paycenter.api.enums.ChannelTypeEnum
     */
    private String channelType;
}
