package cn.com.duiba.kjy.paycenter.api.param.pay;

import cn.com.duiba.kjy.paycenter.api.param.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付订单表
 * @author kjj mybatis generator 
 * @date 2020-02-28
 */
@ToString(callSuper = true)
@Data
@EqualsAndHashCode(callSuper = true)
public class ChargeOrderSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15828685582781432L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付订单号
     */
    private String outTradeNo;

    /**
     * 业务方的订单id
     */
    private String bizOrderNo;

    /**
     * 业务方类型，由支付系统分配给各个业务方
     */
    private Integer bizType;

    /**
     * 渠道返回的交易流水号
     */
    private String transactionNo;

    /**
     * 支付状态 0-订单生成，1-收单成功, 2-收单失败, 3-支付失败, 4-支付成功 5-取消支付 6-退款中 7-退款成功 8-退款失败
     */
    private Integer chargeStatus;

    /**
     * 支付渠道
     */
    private String channelType;

    /**
     * 支付渠道应用ID
     */
    private String appId;

    /**
     * 支付金额，必须大于0, 单位为分
     */
    private Integer amount;

    /**
     * 支付完成时间
     */
    private Date paidTime;

    /**
     * 支付过期时间
     */
    private Date expireTime;

    /**
     * 业务方查询需要的信息，创建订单时自行放入，格式不做要求，业务方自行解析
     */
    private String metaData;

    /**
     * 渠道支付失败码
     */
    private String failureCode;

    /**
     * 渠道支付失败描述
     */
    private String failureMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}