package cn.com.duiba.kjy.paycenter.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.pay.RefundOrderDto;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.BaseRefundRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.BaseCancelResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.BaseRefundResponse;

import java.util.List;

/**
 * 退款相关
 * @author lizhi
 * @date 2020/3/3 2:15 PM
 */
@AdvancedFeignClient
public interface RemoteRefundService {

    /**
     * 微信退款异步接口
     * 返回成功只是提交成功
     *
     * @param refundRequest 退款请求
     * @return 微信退款请求响应
     * @throws BizException bizException
     */
    BaseRefundResponse refund(BaseRefundRequest refundRequest) throws BizException;

    /**
     * 通过商户退款单号查找退款订单流水
     * @param outRefundNo 珊瑚退款单号
     * @return  退款流水
     */
    RefundOrderDto findByOutRefundNo(String outRefundNo) throws BizException;

    /**
     * 通过业务方类型和退款单号查找退款订单流水
     * @param bizRefundNo 业务方的退款订单id
     * @param bizType 业务方类型
     * @return  退款流水
     */
    RefundOrderDto findByBizRefundNoAndBizType(String bizRefundNo, Integer bizType) throws BizException;

    /**
     * 根据第三方交易流水号查询该订单对应的所有退款单（最多100条）
     * @param transactionNo 第三方交易流水号
     * @return 退款流水集合
     */
    List<RefundOrderDto> findByTransactionNo(String transactionNo) throws BizException;

    /**
     * 发起支付撤销
     * 对于支付宝而言:
     *  支付交易返回失败或支付系统超时，调用该接口撤销交易。如果此订单用户支付失败，支付宝系统会将此订单关闭；如果用户支付成功，支付宝系统会将此订单资金退还给用户。
     *  注意：只有发生支付系统超时或者支付结果未知时可调用撤销，其他正常支付的单如需实现相同功能请调用申请退款API。提交支付交易后调用【查询订单API】，没有明确的支付结果再调用【撤销订单API】。
     * @param bizOutNo 业务方单号
     * @param bizType 业务类型
     * @return
     */
    BaseCancelResponse tradeCancel(String bizOutNo,Integer bizType);
}
