package cn.com.duiba.kjy.paycenter.api.dto.config;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 业务方回调配置
 * @author kjj mybatis generator 
 * @date 2020-02-28
 */
@Data
public class BizCallbackConfigDto implements Serializable {

    private static final long serialVersionUID = -3919116963752565352L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务方类型，由支付系统分配给各个业务方
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    private Integer bizType;

    /**
     * 回调类型：1-支付回调，2-退款回调
     * @see cn.com.duiba.kjy.paycenter.api.enums.CallbackTypeEnum
     */
    private Integer callbackType;

    /**
     * mq的topic
     */
    private String mqTopic;

    /**
     * mq的tag
     */
    private String mqTag;
}