package cn.com.duiba.kjy.paycenter.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/5 3:31 PM
 */
@Getter
@AllArgsConstructor
public enum CallbackTypeEnum {

    /**
     * 支付回调
     */
    CHARGE(1, "支付回调"),

    /**
     * 退款回调
     */
    REFUND(2, "退款回调"),

    /**
     * 企业付款到领取结果
     */
    WX_COM_RESULT(3, "企业付款到领取结果"),
    ;

    private final Integer code;

    private final String desc;

    private static final Map<Integer, CallbackTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CallbackTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static CallbackTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
