/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.paycenter.api.enums;

import java.util.HashMap;
import java.util.Map;

public enum ChargeOrderStatusEnum {
    INIT(0, "\u521d\u59cb\u5316\u72b6\u6001"),
    ORDER_SUCCESS(1, "\u7b2c\u4e09\u65b9\u652f\u4ed8\u6536\u5355\u6210\u529f"),
    ORDER_FAIL(2, "\u7b2c\u4e09\u65b9\u652f\u4ed8\u6536\u5355\u5931\u8d25"),
    PAY_SUCCESS(4, "\u652f\u4ed8\u6210\u529f"),
    PAY_FAIL(3, "\u652f\u4ed8\u5931\u8d25"),
    PAY_REVERSED(5, "\u652f\u4ed8\u53d6\u6d88"),
    REFUNDING(6, "\u9000\u6b3e\u4e2d"),
    REFUND_SUCCESS(7, "\u9000\u6b3e\u6210\u529f"),
    REFUND_FAIL(8, "\u9000\u6b3e\u5931\u8d25");

    private Integer code;
    private String desc;
    private static final Map<Integer, ChargeOrderStatusEnum> ENUM_MAP;

    private ChargeOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public static ChargeOrderStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static boolean canCancel(Integer code) {
        ChargeOrderStatusEnum statusEnum = ChargeOrderStatusEnum.getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == INIT || statusEnum == ORDER_SUCCESS || statusEnum == PAY_SUCCESS;
    }

    static {
        ENUM_MAP = new HashMap<Integer, ChargeOrderStatusEnum>();
        for (ChargeOrderStatusEnum tmp : ChargeOrderStatusEnum.values()) {
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }
}

