package cn.com.duiba.kjy.paycenter.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 支付中心分配的业务方类型
 * @author lizhi
 * @date 2020/2/28 11:51 AM
 */
@Getter
@AllArgsConstructor
public enum BizTypeEnum {

    /**
     * 客集集
     */
    KJJ(3, "客集集"),

    /**
     * 客集集红包
     */
    KJJ_RED_PACKET(6, "客集集红包"),

    /**
     * 直播红包企业付款到零钱
     */
    KJJ_LIVE_RED_PACKET_WX_COMPANY(7, "直播红包企业付款到零钱"),

    /**
     * 客集集红包_支付宝版
     */
    KJJ_RED_PACKET_4_ALIPAY(8, "客集集红包_支付宝版"),

    /**
     * 口以小程序付费
     */
    KOUYI_MP_PAY(9, "口以小程序付费"),

    /**
     * 客集集红包企业付款到零钱
     */
    KJJ_RED_PACKET_WX_COMPANY(10, "客集集红包企业付款到零钱"),

    /**
     * 客集集提现企业付款到零钱
     */
    KJJ_WITHDRAW_WX_COMPANY(11, "客集集提现企业付款到零钱"),

    /**
     * 直播访客确认中奖信息
     */
    LIVE_VISITOR_REWARD_CONFIRM(12, "直播访客确认中奖信息"),

    /**
     * 直播成功案例付款到零钱
     */
    LIVE_SUCCESS_AGENT_WX_COMPANY(13, "直播成功案例付款到零钱"),

    /**
     * 直播支付
     */
    LIVE_PAY(21, "直播支付"),


    /**
     * 集客助手奖励,付款到零钱
     */
    KJJ_AWARD_PAY_WX_COMPANY(95, "集客助手奖励,付款到零钱"),
    
    /**
     * 直播补偿金额,付款到零钱
     */
    LIVE_DISCOUNT_PAY_WX_COMPANY(96, "直播补偿金额,付款到零钱"),

    /**
     * 兑吧直播红包企业付款到零钱
     */
    DUI_BA_LIVE_RED_PACKET_WX_COMPANY(97, "兑吧直播红包企业付款到零钱"),

    /**
     * 银行个金-客户红包奖励付款到零钱
     */
    DUI_BA_DIRECT_RED_WX_COMPANY(98, "银行个金-客户红包奖励付款到零钱")

    ;

    private final Integer code;

    private final String desc;

    private static final Map<Integer, BizTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BizTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static BizTypeEnum getBizTypeEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    /**
     * 返回bizType是否有效
     * @param bizType 业务方类型
     * @return 是否有效
     */
    public static boolean isActive(Integer bizType) {
        if (bizType == null) {
            return false;
        }
        return getBizTypeEnumByCode(bizType) != null;
    }
}
