package cn.com.duiba.kjy.paycenter.api.remoteservice.wx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayLiteSignRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayLiteChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPaySignResponse;

import javax.annotation.Nullable;

/**
 * 微信支付相关
 * @author 吴文哲
 * @date 2021/8/17 4:40 下午
 **/
@AdvancedFeignClient
public interface RemoteWxPayService {

    /**
     * 微信小程序生成签名信息
     * @param chargeRequest 支付请求
     * @return WxPayLiteChargeResponse
     */
    WxPayLiteChargeResponse getWxPayLiteSignInfo(WxPayLiteSignRequest chargeRequest) throws BizException;

    /**
     * 根据订单号，生成签名信息
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     * @param bizOrderNo 业务订单号
     * @param appId 主体ID
     * @return 签名信息，获取失败时，返回null
     */
    @Nullable
    WxPaySignResponse getWxPayMpSignInfo(Integer bizType, String bizOrderNo, String appId);
}
