/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.paycenter.api.enums.order;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OrderHandlerTypeEnum {
    CANCEL(1, "\u8ba2\u5355\u81ea\u52a8\u53d6\u6d88"),
    SYNC_PLACE_ORDER(2, "\u540c\u6b65\u4e0b\u5355\u72b6\u6001");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, OrderHandlerTypeEnum> ENUM_MAP;

    public static OrderHandlerTypeEnum getByType(Integer handlerType) {
        if (handlerType == null) {
            return null;
        }
        return ENUM_MAP.get(handlerType);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private OrderHandlerTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(OrderHandlerTypeEnum.values()).collect(Collectors.toMap(OrderHandlerTypeEnum::getType, Function.identity())));
    }
}

