package cn.com.duiba.kjy.paycenter.api.dto.citic;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 全付通退款单
 * @author kjj mybatis generator 
 * @date 2023-01-10
 */
@Data
public class RefundOrderCiticDto implements Serializable {
     
    private static final long serialVersionUID = 16733217617209747L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商户编号
     */
    private String merNo;

    /**
     * 商户退款订单号
     */
    private String refundNo;

    /**
     * 申请退货金额,分为单位
     */
    private Integer refundAmt;

    /**
     * 商户原始支付订单号
     */
    private String orderNo;

    /**
     * 商户原支付流水号
     */
    private String merJnlNo;

    /**
     * 原交易智能收单流水号
     */
    private String tranJnlNo;

    /**
     * 智能收单退款流水号
     */
    private String rfuTranJnlNo;

    /**
     * 交易状态,01：处理中 02：交易成功 03：交易失败 04：交易未知
     */
    private String stt;

    /**
     * 清算日期，格式为yyyyMMdd
     */
    private String settleDate;

    /**
     * 交易完成时间，yyyy-MM-dd hh:mm:ss
     */
    private String tranEndDate;

    /**
     * 信息标识 AAAAAAA代表成功
     */
    private String retCode;

    /**
     * 返回标识信息描述 有提示信息时返回
     */
    private String retMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}