package cn.com.duiba.kjy.paycenter.api.dto.payment.response.alipay;

import cn.com.duiba.kjy.paycenter.api.dto.payment.response.BaseChargeNotifyResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付宝统一支付回调回执
 * @author 吴文哲
 * @date 2020-07-09 20:11
 **/
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AliPayChargeNotifyResponse extends BaseChargeNotifyResponse {

    /**
     * 商家在交易中实际收到的款项，单位为分
     */
    private Long receiptAmount;

    /**
     * 用户在交易中支付的可开发票的金额，单位为分
     */
    private Long invoiceAmount;

    /**
     * 用户在交易中支付的金额，单位为分
     */
    private Long buyerPayAmount;

}
