package cn.com.duiba.kjy.paycenter.api.enums.unionpay;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 银联银行卡编码枚举
 *
 * @author xuzhigang
 * @date 2022/10/21 3:11 下午
 **/
@Getter
@AllArgsConstructor
public enum UnionPayBankCodeEnum {
    ICBC("工商银行"),
    ABC("农业银行"),
    CCB("建设银行"),
    PSBC("邮储银行 "),
    CITIC("中信银行 "),
    CEB("光大银行"),
    HXBANK("华夏银行"),
    CMBC("民生银行"),
    GDB("广发银行"),
    CIB("兴业银行"),
    SPDB("浦发银行"),
    CMB("招商银行"),
    PAB("平安银行"),
    BOS("上海银行"),
    BOB("北京银行"),
    BON("宁波银行"),
    BOJ("江苏银行"),
    BRCB("北京农商"),
    GRCB("广州农商"),
    BOZ("浙商银行"),
    SRCB("深圳农村商业银行"),
    SHRCB("上海农村商业银行"),
    CGNB("四川天府银行"),
    BCM("交通银行"),
    CABANK("长安银行"),
    HSBC("汇丰银行"),
    ZBCB("齐商银行"),
    ZJNX("浙江农信"),
    NXBANK("宁夏银行"),
    WHB("威海市商业银行"),
    ZYB("中原银行"),
    DLB("大连银行"),
    JZB("锦州银行"),
    MSB("蒙商银行"),
    JYNSB("江阴农商银行"),
    WFB("潍坊银行"),
    QLB("齐鲁银行"),
    BBWB("广西北部湾银行"),
    ;
    /**
     * 银行名称
     */
    private final String bankName;

    private static Map<String, String> map = new HashMap<>();

    static {
        for (UnionPayBankCodeEnum value : values()) {
            map.put(value.name(), value.getBankName());
        }
    }

    public static String getNameByCode(String bankCode) {
        String name = map.get(bankCode);
        if (StringUtils.isBlank(name)) {
            return "";
        }
        return StringUtils.join(name, "信用卡");
    }
}
