package cn.com.duiba.kjy.paycenter.api.param.wxpay;

import cn.com.duiba.kjy.paycenter.api.param.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信类型支付
 * @author kjj mybatis generator 
 * @date 2020-02-28
 */
@ToString(callSuper = true)
@Data
@EqualsAndHashCode(callSuper = true)
public class ChargeOrderWxSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15828685582809368L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 微信app_id
     */
    private String appId;

    /**
     * 微信支付分配的商户号
     */
    private String mchId;

    /**
     * 商品描述信息
     */
    private String body;

    /**
     * 商户订单号
     */
    private String outTradeNo;

    /**
     * 订单总金额，单位为分，必须大于0
     */
    private Integer totalFee;

    /**
     * 支持IPV4和IPV6两种格式的IP地址。用户的客户端IP
     */
    private String spbillCreateIp;

    /**
     * 订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010
     */
    private String timeExpire;

    /**
     * 异步接收微信支付结果通知的回调地址，通知url必须为外网可访问的url，不能携带参数
     */
    private String notifyUrl;

    /**
     * 交易类型,JSAPI--JSAPI支付（或小程序支付）、NATIVE--Native支付、APP--app支付，MWEB--H5支付，MICROPAY-付款码支付
     */
    private String tradeType;

    /**
     * 微信用户在商户对应appid下的唯一标识
     */
    private String openId;

    /**
     * 微信支付订单号
     */
    private String transactionId;

    /**
     * 交易状态,SUCCESS—支付成功、REFUND—转入退款、NOTPAY—未支付、CLOSED—已关闭、REVOKED—已撤销（付款码支付）、USERPAYING--用户支付中（付款码支付）、PAYERROR--支付失败(其他原因，如银行返回失败)
     */
    private String tradeState;

    /**
     * 交易状态描述
     */
    private String tradeStateDesc;

    /**
     * 订单支付时间，格式为yyyyMMddHHmmss
     */
    private String timeEnd;

    /**
     * 错误代码
     */
    private String errCode;

    /**
     * 错误代码描述
     */
    private String errCodeDes;

    /**
     * 是否关注公众账号
     */
    private String isSubscribe;

    /**
     * 付款银行
     */
    private String bankType;

    /**
     * 现金支付金额，单位为分
     */
    private Integer cashFee;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}